/* * * * * * * * * * * * * * * * * * * * * * * * * *
 * x.c - the main file for X                       *
 * Written by Jeff Weeks                           *
 * (c)1996 Code X software                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * */

/* standard header files... lots of 'em */
#include <pc.h>                        /* dos specific stuff */
#include <dos.h>                       /* more dos specific stuff */
#include <time.h>                      /* for clock, fps checking */
#include <math.h>                      /* sin, cos, etc */
#include <dpmi.h>                      /* hmm... I wonder why this is here */
#include <go32.h>                      /* selectors, etc */
#include <stdio.h>                     /* if you don't know what this is... */
#include <conio.h>                     /* same goes for this */
#include <assert.h>                    /* do I even use this? */
#include <string.h>                    /* the name says it all */
#include <stdlib.h>                    /* again, same at stdio */
#include <sys/farptr.h>                /* for far pointer access */
#include <sys/nearptr.h>               /* for near pointer access */
#include <sys/movedata.h>              /* for data manipulation */

/* my own user made header files */
#include "x.h"             /* function prototypes, variables, etc */
#include "pcx.h"           /* my pcx class */
#include "video.h"         /* my video class */
#include "hfield.h"        /* my height field class */
#include "keyboard.h"      /* my C++ wrapper for Martynas' ASM code */

/* my standard X variables (X as in the game, not the OS :) */
int sine[256];                         /* our sine and cosine tables */
int cosine[256];                       /* which fit in an 8-bit register */
int fps;                               /* our frames per second counter */
int start;                             /* used for fps */
int end;                               /* used for fps */
Video video;                           /* an instance of my video class */
HField *land;                           /* an instance of my height field class */
Keyboard kb;                           /* an instance of my keyboard wrapper */

int main(int argc, char *argv[]) {
  setup();                             /* perform any setup code (tables,etc) */
  video.open_window();                 /* open a window (origionally X11) */
  if(argc > 2) land = new HField(argv[1], argv[2]);
  else land = new HField("emap.pcx","cmap.pcx");
  start = clock();                     /* used in our fps calculation */
  event_loop();                        /* start the main loop */
  video.close_window();                /* close our window */
  end = clock();
  printf("Frames/second: %f\n\n", (float)fps/((end-start)/CLK_TCK));
  cleanup();			                  /* free all allocated memory */
  return 0;
}

void setup(void) {
  create_tables();                     /* create our sine/cosine tables */
  kb.init();                           /* initialize our keyboard interrupt */
  kb.chain(OFF);                       /* we don't want DOS doing any buffering */
  return;
}

void create_tables(void) {
  int i;
  /* Calculate the sine and cosine tables (in fixed point) in advance so that
     calculations are much faster.  We only go to 256 so that the number fits
     nicely into an 8-bit register.  Because of this we use (PI/128) instead of
     PI/180 for our radian/degree conversions.  We also multiply our final
     result by 256 for 8 digits of decimal acuracy (24.8 because we use a 32
     bit int... technically 8.8 would be fine but then I'd be using a 16-bit 
     register and that's no good) */
  for(i = 0; i < 256; i++) {
    /*
    sine[i]   = int(sin(i*2*3.141592/256.0)*256);
    cosine[i] = int(cos(i*2*3.1415692/256.0)*256);
    */
    sine[i]   = int(sin(i*3.1415926/128)*256);
    cosine[i] = int(cos(i*3.1415926/128)*256);
  }
  return;
}

void cleanup(void) {
  delete land;                   // Delete our land class.  Sounds so harsh :)
  kb.close();                    // take out our user defined kb interrupt
  return;
}

/***************************************************************************
 * event_loop: the main event loop for the game                            *
 ***************************************************************************/
int event_loop(void) {
  int done = 0;

  /* event loop */
  while(!done) {
    //if(land->speed > 0) land->speed --;    // friction!
    land->speed = 0;                         // walking... just stop!

    // test a bunch of keys using our C++ keyboard class
    if(kb.key_down(SCAN_Q) ||
       kb.key_down(SCAN_ESC)) done = 1;      // we're done
    // if left or right is pushed, rotate!  Simple as that.
    if(kb.key_down(SCAN_LEFT)) {
      if(land->angle > 0) land->angle--;
      else land->angle = 255;
    }
    if(kb.key_down(SCAN_RIGHT)) {
      if(land->angle < 255) land->angle++;
  	   else land->angle = 0;
    }
    // this puppy handles strafing, simply by setting the strafe flag, and
    // making sure the person is moving is left or right is pressed
    if(kb.key_down(SCAN_ALT)) {
        land->strafe = -1;
        if(kb.key_down(SCAN_LEFT)) land->speed = -(5<<8);
        if(kb.key_down(SCAN_RIGHT)) land->speed = (5<<8);
    }
    else land->strafe = 0;

    // Make sure this comes after the strafing code.  This simply makes the
    // player move if up or down is pressed.  We don't want to strafe if we're
    // moving forward or backward so we set the strafe flag to off.
    if(kb.key_down(SCAN_UP)) {
      land->speed = (5<<8);
      land->strafe = 0;
    }
    if(kb.key_down(SCAN_DOWN)) {
      land->speed = -(5<<8);
      land->strafe = 0;
    }

    /*
    if(kb.key_down(SCAN_DOWN)) land.speed = 0;
    if(kb.key_down(SCAN_GREY_PLUS)) land.height += 10;
    if(kb.key_down(SCAN_GREY_MINUS)) land.height -= 10;
    */
    // render our next frame
    land->render();
  }
  return 0;
}