#include <pc.h>
#include <go32.h>
#include <dpmi.h>
#include <memory.h>
#include <string.h>
#include <sys/farptr.h>
#include <sys/nearptr.h>

#include "video.h"

//#define USE_ASM

void Video::putpixel(int x, int y, char c) {
  //if(x > 0 && x < 320 && y > 0 && y < 200)
  if((unsigned)y < 200)
    if((unsigned)x < 320)
  //  _farpokeb(_dos_ds,0xA0000+(y*max_x+x),c);
  virt[y*max_x+x] = c;
}

/***************************************************************************
 * open_window: open the graphics array (320x200x256)                      *
 ***************************************************************************/
void Video::open_window(void) {
  __dpmi_regs regs;
  
  /* setup our screen width and height */
  max_x = 320; max_y = 200;
  virt = new char[max_x*max_y];
  /* actually set the video mode */
  regs.x.ax = 0x13;
  __dpmi_int(0x10,&regs);
  
  return;
}

/***************************************************************************
 * close_window: closes the graphics array                                 *
 ***************************************************************************/
void Video::close_window(void) {
  __dpmi_regs regs;
  
  /* back to text mode */
  regs.x.ax = 0x3;
  __dpmi_int(0x10,&regs);
  return;
}

void Video::setrgb(char index, char r, char g, char b) {
  outportb(0x03c8, index);
  outportb(0x03c9, r);
  outportb(0x03c9, g);
  outportb(0x03c9, b);
}

void Video::clear_screen(void) {
  memset(virt,0, max_x*max_y);
}

void Video::blitscreen(void) {
  // enable near pointers
  __djgpp_nearptr_enable();

  // wait for the vertical refresh rate
#if !defined USE_ASM
  while(inportb(0x3DA)&0x08)  { }
  while(!inportb(0x3DA)&0x08) { }
#else
  // Some ASM code to wait for a verticle retrace
  __asm__ __volatile__("
    movw $0x3DA, %%dx
  NoSync:
    inw  %%dx, %%al
    andb $0x8, %%al
    jnz  NoSync
  Sync:
    inw  %%dx, %%al
    andb $0x8, %%al
    jz Sync"
    :
    :
    : "dx", "ax"
  );
#endif

  // copy our screen to video memory
#if !defined USE_ASM
  memcpy((char*)(0xa0000 + __djgpp_conventional_base),virt,64000);
#else
  // here's some ASM to perform the copy
  __asm__ __volatile__("
    pushw %%es
    movw %0, %%es
    movl $0xA0000, %%edi

    movl  $16000, %%ecx

    cld
    rep; movsl
    pop %%es"
    :
    : "g" (_go32_conventional_mem_selector()), "S" (virt)
    : "si", "cx", "di"
  );
#endif
  // disable near pointers
  __djgpp_nearptr_disable();
  // set our background to 0
  memset(virt,0,320*200);
}
