/*
 * pcx loading routines
 * converted to DJGPP V2 by Jeff Weeks
 */

#ifndef __PCXH__
#define __PCXH__

#include <stdio.h>

#define NO_ERROR             0
#define FILE_ERROR           1
#define MEMORY_ERROR         2
#define TOO_MANY_ARGUMENTS   3

typedef struct { unsigned char r,g,b; } RGB;

/* PCX FILE HEADER STRUCTURE */
typedef struct  {
  char id;                      /* manufacturer's id (always 0xa0)  */
  char ver;                     /* PCX version                      */
  char encoding;                /* compression method (always 1)    */
  char bitsPerPixel;            /* the # of bits per pixel          */
  short xMin, yMin;             /* image start                      */
  short xMax,yMax;              /* image size                       */
  short hRes;                   /* horizontal resolution            */
  short vRes;                   /* vertical reoslution              */
  char palette16[48];           /* 16 color pallette               
                                    (not used with 256 color)        */
  char reserved;                /* not used                         */
  char colorPlanes;             /* # of color planes                */
  short bytesPerLine;           /* # of bytes per line              */
  short paletteType;            /* pallete type (grey or color)     */
  char filler[58];              /* not used                         */
} PCX_HEADER;


/* PCX FILE STRUCTURE */
typedef struct {
  PCX_HEADER header;                 /* The header data        */
  long imageSize;                    /* the image size         */
  unsigned char filename[80];        /* PCX file name          */
  unsigned char *image;              /* pointer to image data  */
  RGB palette[256];      	      /* PCX palette            */
} PCX;

/* function prototypes */
class Pcx {
  public:

  PCX *info;
  FILE *pcxfile;
  Pcx(void);
  int  load(char *filename);
  void loadimage(void);
  void loadheader(void);
  void loadpalette(void);
  void displayheader(void);
};

#endif
