/*
 * A set of functions to read a PCX file,
 * Converted to DJGPP V2 by Jeff Weeks
 */

#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <string.h>
#include <memory.h>

#include "pcx.h"

Pcx::Pcx(void) {
  info = new PCX;
}

/*_________________________________________________________________________
 |                                                                         |
 | PcxLoad()                                                               |
 | Read in a pcx file and load into memory.                                |
 |_________________________________________________________________________|*/
int Pcx::load(char *filename) {
  /* Open the PCX file */
  if ((pcxfile=fopen(filename, "rb"))==NULL) return 0;

  /* initialize the file name element */
  strcpy((char *)info->filename, filename);

  /* Read the file header */
  loadheader();

  /* Read the image data */
  loadimage();

  /* read the palette data */
  loadpalette();

  /* close PCX file */
  fclose(pcxfile);
  return 1;
}

/*_________________________________________________________________________
 |                                                                         |
 | PcxLoadImage()                                                          |
 | Grab image from pcx file and stores it in image buffer.                 |
 |_________________________________________________________________________|*/
void Pcx::loadimage(void) {
  const int BYTEMODE=0, RUNMODE=1;
  int mode=BYTEMODE;
  static unsigned char outbyte, bytecount;
  long pcxwidth, pcxheight;
  long i;


  /* get the size of the image stored */
  pcxwidth  = info->header.xMax - info->header.xMin + 1;
  pcxheight = info->header.yMax - info->header.yMin + 1;
  info->imageSize=pcxwidth*pcxheight;

  /* create storage for image */
  info->image = (unsigned char *)malloc(info->imageSize);

  /* skip past header */
  fseek(pcxfile, 128L, SEEK_SET);

  /* loop through all bytes of image */
  for (i=0; i < info->imageSize; i++) {
    /* see if we need to read a byte */
    if (mode==BYTEMODE) {
      /* get byte */
      outbyte=(unsigned char)fgetc(pcxfile);
      /* see if byte says we have a run */
      if (outbyte>0xbf) {
        /*
         * get the number of bytes in the run
         * (maximum run lenght is 63 [0x3f])
         * so we strip the count from the byte
         */
         bytecount = (int)((int)outbyte & 0x3f);
         /* get the color byte that is set for the run */
         outbyte=(unsigned char)fgetc(pcxfile);
         /* if we still have bytes in the run */
         if (--bytecount > 0)
         /* keep us in run length mode */
         mode = RUNMODE;
       }
     }
     /*
      * while in run length mode
      * decrement the byte counter
      * until we are empty
      */
     else if (--bytecount == 0)
     /* then reset to byte mode */
     mode=BYTEMODE;
     /* store the byte in our image array */
     info->image[i]=outbyte;
  }
}


/*_________________________________________________________________________
 |                                                                         |
 | PcxLoadHeader()                                                         |
 | Grab header data from pcx file and store in header_struct.              |
 |_________________________________________________________________________|*/
void Pcx::loadheader(void) {
  fread((char *)&info->header, sizeof(PCX_HEADER), 1, pcxfile);
}


/*_________________________________________________________________________
 |                                                                         |
 | PcxLoadPalette()                                                        |
 | Grab palette from pcx file and store in palette buffer.                 |
 |_________________________________________________________________________|*/
void Pcx::loadpalette(void) {
  unsigned int i, j;

  fseek(pcxfile, -768L, SEEK_END);
  for (i=0; i<256; i++) {
    //for (j=0; j<3; j++)
    //  pcx->palette[i*3+j]=fgetc(pcxfile)/*>>2*/;
    info->palette[i].r = fgetc(pcxfile)>>2;
    info->palette[i].g = fgetc(pcxfile)>>2;
    info->palette[i].b = fgetc(pcxfile)>>2;
  }
}


/*_________________________________________________________________________
 |                                                                         |
 | PcxDisplayHeader()                                                      | 
 | Displays header information contained in the header_struct.             |
 |_________________________________________________________________________|*/
void Pcx::displayheader(void) {
/*
  printf("\n\n Contents of the PCX file header");
  printf("\n for %s:",pcx->filename);
  printf("\n --------------------------------");
  printf("\n PCX Manufacturer ID is   : %d",pcx->header.manufacturer);
  printf("\n PCX version is           : %d",pcx->header.version);
  printf("\n PCX enoding method is    : %d",pcx->header.encoding);
  printf("\n Bits per pixel are       : %d",pcx->header.bits_per_pixel);
  printf("\n Starting X is            : %d",pcx->header.xMin);
  printf("\n Starting Y is            : %d",pcx->header.yMin);
  printf("\n Horizontal size is       : %d",pcx->header.xMax);
  printf("\n Vertical size is         : %d",pcx->header.yMax);
  printf("\n Horizontal resolution is : %d",pcx->header.hres);
  printf("\n Vertical resolution is   : %d",pcx->header.vres);
  printf("\n EGA palette is           : %s",pcx->header.palette16);
  printf("\n RESERVED                   %c",pcx->header.reserved);
  printf("\n Number of bit planes is  : %d",pcx->header.color_planes);
  printf("\n Number of bytes per row  : %d",pcx->header.bytes_per_line);
  printf("\n Palette information is   : %d",pcx->header.palette_type);
  printf("\n\n");
  getch();
*/
}
