#include "x.h"

typedef struct {
  int h,c;
} buf_data;

typedef struct {                        /* a 2D point type definition */
  int x, y;
} point;

typedef struct current_view {           /* this structure holds all the info */
  point left, right, center;            /* needed to create a 3D view of */
  int z;                                /* the emap based on the players */
  //int look_at;                          /* position, angle, and altitude */
};

class HField {
  public:
    char *emap;                            /* the elevation/height map */
    char *cmap;                            /* the colour map */
    int angle;                             /* the angle we're looking at */
    int direction;
    int speed;                             /* our speed! */
    int strafe;
    int MAP_X, MAP_Y;                      /* the map width/height */
    int height;                            /* the height of the user */
    buf_data *tbuf;                        /* the top buffer for engine */
    buf_data *bbuf;                        /* the bottom buffer for engine */
    int leftx[256],  lefty[256];
    int rightx[256], righty[256];
    current_view view;

    HField(void);
    HField(char *emap, char *cmap);
    void load_from_PCX(char *emap, char *cmap);
    void render(void);
    void vertical_lines(void);
    void set_view(int look_at, int direction, int speed);
};
