#include <memory.h>
#include <string.h>

#include "hfield.h"
#include "video.h"
#include "pcx.h"
#include "x.h"

extern Video video;
extern int fps;
extern int sine[256];
extern int cosine[256];

HField::HField(void) {
  angle = direction = speed = strafe = 0;
  height=100;

  // precalculate rotation angles.  Small speed up.
  for(int i = 0; i < 256; i++) {
    lefty[i]  = (DEPTH * cosine[i]) +
                (SLOPE * DEPTH * sine[i]);

    leftx[i]  = (DEPTH * sine[i]) -
	             (SLOPE * DEPTH * cosine[i]);

    righty[i] = (DEPTH * cosine[i]) -
	             (SLOPE * DEPTH * sine[i]);

    rightx[i] = (DEPTH * sine[i]) +
	             (SLOPE * DEPTH * cosine[i]);
  }
}

HField::HField(char *file_emap, char *file_cmap) {
  angle = direction = speed = strafe = 0;
  height=100;

  // precalculate rotation angles
  for(int i = 0; i < 256; i++) {
    lefty[i]  = (DEPTH * cosine[i]) +
                (SLOPE * DEPTH * sine[i]);

    leftx[i]  = (DEPTH * sine[i]) -
	             (SLOPE * DEPTH * cosine[i]);

    righty[i] = (DEPTH * cosine[i]) -
	             (SLOPE * DEPTH * sine[i]);

    rightx[i] = (DEPTH * sine[i]) +
	             (SLOPE * DEPTH * cosine[i]);
  }

  load_from_PCX(file_emap,file_cmap);
}

void HField::load_from_PCX(char *file_emap, char *file_cmap) {
  Pcx pcx_cmap, pcx_emap;
  int size,i;
  
  tbuf = new buf_data[video.max_x];
  bbuf = new buf_data[video.max_x];

  /* load in the emap, allocate memory for it, and copy it to "emap" */
  if(!pcx_emap.load(file_emap)) {
    video.close_window();
    printf("Couldn't load PCX: %s", file_emap);
    exit(1);
  }
  emap = (char *)malloc(pcx_emap.info->imageSize);
  memmove(emap, pcx_emap.info->image, pcx_emap.info->imageSize);

  /* setup our map width and height (REMEMBER the +1... this almost
     killed me!!! :) */
  MAP_X = (pcx_emap.info->header.xMax - pcx_emap.info->header.xMin)+1;
  MAP_Y = (pcx_emap.info->header.yMax - pcx_emap.info->header.yMin)+1;
  
  /* load in our cmap.  Use the same processes as our emap */
  if(!pcx_cmap.load(file_cmap)) {
    video.close_window();
    printf("Couldn't load PCX: %s", file_cmap);
    exit(1);
  }
  cmap = (char *)malloc(pcx_cmap.info->imageSize);
  memmove(cmap,pcx_cmap.info->image, pcx_cmap.info->imageSize);
  
  /* set the palette */
  for(i = 0; i < 256; i++)
    video.setrgb((unsigned char)i,pcx_cmap.info->palette[i].r,
                                  pcx_cmap.info->palette[i].g,
                                  pcx_cmap.info->palette[i].b);

  /* setup our initial map position (middle) */
  view.center.x = MAP_X/2*256;
  view.center.y = MAP_Y/2*256;
  set_view(angle,angle,speed);
  return;
}

void HField::render(void) {
  int tx1_step, ty1_step;		/* triangle x and y steps */
  int tx2_step, ty2_step;		/* triangle x and y steps */
  int tx1,ty1,tx2,ty2;
  int hx_step, hy_step;			/* heights  x and y steps */
  int hx,hy;
  int x1,y1,x2,y2;      		/* these are here for simplicity */
  int i, c, x;			         /* general purpose counters */
  int pos, per, depth;        /* these are used for some optomizations */
  buf_data *temp;

  fps++;
  set_view(angle,direction,speed);

  /* first we calculate our triangle traversing steps.  What these numbers
     represent is what you add to the current x and y to get one step closer 
     to the viewer (ie: step up one rendering line) */
  tx1_step = (view.center.x - view.left.x) / DEPTH;
  ty1_step = (view.center.y - view.left.y) / DEPTH;
  tx2_step = (view.center.x - view.right.x) / DEPTH;
  ty2_step = (view.center.y - view.right.y) / DEPTH;

  tx1 = view.left.x;  ty1 = view.left.y;
  tx2 = view.right.x; ty2 = view.right.y;

  hx_step = ((tx2-tx1))/video.max_x;
  hy_step = ((ty2-ty1))/video.max_x;

  hx = tx1; hy = ty1;
  depth = (DEPTH+1);

  /* take the viewers height based on what their standing on, and add 50,
     this effectly makes the user's height 50 */
  height = emap[(view.center.y>>8)*MAP_X+(view.center.x>>8)] + 50;

  // do the first line
  per = int(60.0 / depth * 256.0);
  for(c = 0; c < video.max_x; c++) {
    pos = int((hy>>8)*MAP_X+(hx>>8));
    tbuf[c].c = cmap[pos];
    tbuf[c].h = 100-(emap[pos]-height)*per/256;
    hx+=hx_step;
    hy+=hy_step;
  }
  tx1 += tx1_step;   // increase left side
  ty1 += ty1_step;
  tx2 += tx2_step;   // increase right side
  ty2 += ty2_step;
  depth--;

  // do the intermediate lines
  for(i = DEPTH-1; i > 2; i--) {
    hx_step = (tx2-tx1)/video.max_x;
    hy_step = (ty2-ty1)/video.max_x;
    hx = tx1; hy = ty1;
    per = int(60.0 / depth * 256.0);
    for(c = 0; c < video.max_x; c++) {
      pos = int((hy>>8)*MAP_X+(hx>>8));
      bbuf[c].c = cmap[pos];
      bbuf[c].h = 100-(emap[pos]-height)*per/256;
      hx+=hx_step;
      hy+=hy_step;
    }
    tx1 += tx1_step;    // increase left side
    ty1 += ty1_step;
    tx2 += tx2_step;    // increase right side
    ty2 += ty2_step;
    vertical_lines();
    depth--;

    // copy the bottom buffer up to the top buffer
    temp = tbuf;
    tbuf = bbuf;
    bbuf = temp;
  }

  // do the last line
  hx_step = (tx2-tx1)/video.max_x;
  hy_step = (ty2-ty1)/video.max_x;
  hx = tx1; hy = ty1;
  for(c = 0; c < video.max_x; c++) {
    pos = (hy>>8)*MAP_X+(hx>>8);
    bbuf[c].c = cmap[pos];
    bbuf[c].h = 199;
    hx+=hx_step;
    hy+=hy_step;
  }
  vertical_lines();

  video.blitscreen();
  return;
}

void HField::vertical_lines(void) {
  int pos, i;
  int length, x;
  for(x = 0; x < video.max_x; x++) {
    if(bbuf[x].h > tbuf[x].h) {
      /* perform clipping */
      if(tbuf[x].h < 0) tbuf[x].h = 0;
      if(tbuf[x].h > 199) tbuf[x].h = 199;
      if(bbuf[x].h < 0) bbuf[x].h = 0;
      if(bbuf[x].h > 199) bbuf[x].h = 199;

      length = bbuf[x].h - tbuf[x].h;
      pos = (tbuf[x].h*video.max_x+x);
      for(i = length; i; i--) {
        video.virt[pos] = tbuf[x].c;
        pos += video.max_x;
      }
    }
  }
  return;
}

void HField::set_view(int look_at, int direction, int speed) {
  // if we're strafing then we go at 90 degree's to the actual user angle.
  // Since we're using 256 degree's, 90 is actually 64 :)
  if(strafe) {
    view.center.x += ((speed*sine[((look_at+64)%256)]) >> 8);
    view.center.y += ((speed*cosine[((look_at+64)%256)]) >> 8);
  } else {
    view.center.x += ((speed*sine[look_at]) >> 8);
    view.center.y += ((speed*cosine[look_at]) >> 8);
  }

  /* check if the player is in bounds
     There's probably a better way of doing this */
  if(view.center.x < BORDER) view.center.x = BORDER;
  if(view.center.x > ((MAP_X*256)-BORDER)) view.center.x = ((MAP_X*256)-BORDER);
  if(view.center.y < BORDER) view.center.y = BORDER;
  if(view.center.y > ((MAP_Y*256)-BORDER)) view.center.y = ((MAP_Y*256)-BORDER);

  /* calculate the left point (precalcuated in contructor) */
  view.left.y = (lefty[look_at]) + view.center.y;
  view.left.x = (leftx[look_at]) + view.center.x;

  /* calculate the right point (precalcuated in contructor) */
  view.right.y = (righty[look_at]) + view.center.y;
  view.right.x = (rightx[look_at]) + view.center.x;
}
