/* Goraud shaded polygon demo.  Origionally written by Chris Egerter for
 * watcom C.  Converted/updated to DJGPP by Jeff Weeks (pweeks@execulink.com).
 */

#include <dos.h>
#include <dpmi.h>
#include <go32.h>
#include <conio.h>
#include <stdlib.h>
#include <sys/farptr.h>

#define MAX_X  320
#define MAX_Y  200
#define putpixel(x,y,c) _farpokeb(_dos_ds, 0xA0000+y*320+x,c);

signed int startx[MAX_Y];
signed int endx[MAX_Y];
unsigned char startcol[MAX_Y];
unsigned char endcol[MAX_Y];

typedef struct {
  int x,y;
  unsigned char col;
} gpoint;

// Setup the video mode and change the palette
void initgraph(void) {
  int i;
  float inc=(float)64.0/256.0;   // used to smoothly increment our colour values
  float r=0.0, g=0.0, b=0.0;     // start all colours off at zero

  __dpmi_regs regs;              // go into 320x200x256
  regs.x.ax = 0x13;
  __dpmi_int(0x10,&regs);

  // this makes a nice smooth palette
  for(i = 0; i < 256; i++) {
    outportb(0x3C8, i);
    outportb(0x3C9, (char)(r*0.8));
    outportb(0x3C9, (char)(g*0.6));
    outportb(0x3C9, (char)b);
    r+=(float)inc; g+=(float)inc; b+=(float)inc;
  }
}

void closegraph(void) {
  __dpmi_regs regs;                    // go back to 80x25 text
  regs.x.ax = 0x3;
  __dpmi_int(0x10,&regs);
}

// draws a shaded line from (x1,y) to (x2,y) using gradient colours
// between c1 and c2
void shadedline (int x1, int c1, int x2, int c2, int y) {
  int length;
  int numcolours;
  int colour;
  int inc, x;

  length = x2 - x1 + 1;                // find the length of the line
  if (length > 0) {
    numcolours = c2 - c1 + 1;           // how many colours do we have to span

    colour = c1 << 8;                  // we're using fixed point 24.8
    // this will find the value needed to smoothly increment between colours
    inc = ((long)numcolours << 8) / (long)length;
    for (x = x1; x <= x2; x++) {
      putpixel(x, y, colour >> 8);
      colour += inc;
    }
  }
  return;
}

// this is a modified fixed point line drawing function which will
// store the line's x's and colours in our global arrays, which will later
// be used to actually draw the polygon
void gpolyline (int x1, int y1, int c1, int x2, int y2, int c2) {
  int  y;                              // we loop through all y's
  long x, xinc;                        // and find the corresponding x with these
  long colour, cinc;                   // and the corresponding colour with these

  if (y2 != y1) {                      // we don't want a horizontal line
    if (y2 < y1) {                     // make sure we're going the right way
      y1 ^= y2;                        // if not, switch our y's, x's and colour's
      y2 ^= y1;
      y1 ^= y2;

      x1 ^= x2;
      x2 ^= x1;
      x1 ^= x2;

      c1 ^= c2;
      c2 ^= c1;
      c1 ^= c2;
    }

    x = (long)x1<<8;                   // start off at our first x
    // this will find what we need to increment to get to our next x
    xinc = ((long)(x2 - x1)<<8) / ((long)(y2 - y1));

    colour = (long)c1 << 8;            // start off at our first colour
    // this will fidn what we need to increment to get to our next colour
    cinc = ((long)(c2 - c1) << 8) / ((long)(y2 - y1));

    // Here we skip the first point so that we don't end up storing the
    // point where two lines meet, twice.  Resulting in a single point drawn.
    x += xinc;
    y1++;

    // now we loop through the y's
    for (y = y1; y <= y2; y++) {
      if ((y >= 0) & (y < 200))        // check if we're in bounds
        if (startx[y] == -16000) {     // overwrite if unused (-16000)
          startx[y] = x>>8;
          startcol[y] = colour >> 8;
        }
      else {
        endx[y] = x>>8;                // else store as the last coordinate
        endcol[y] = colour >> 8;
      }
      x += xinc;                       // increment our x
      colour += cinc;                  // and colour values
    }
  }
}

// Draws a shaded polygon given an array of vertices
void gpoly(gpoint *vertexlist, int numvertex) {
  int i;
  gpoint *curpt,*nextpt;
  // Two pointers to a vertex. These are used to connect to vertices
  // together in when calling the gpolyline routine.

  curpt = vertexlist;         // Set to the first vertex in the array
  nextpt = vertexlist + 1;    // and to the second vertex

  for (i = 0; i < 200; i++) {
    startx[i] = endx[i] = -16000;      // Set up our impossible values
  }

  for (i = 1; i < numvertex; i++) {
    // Calculate the edge of this line
    gpolyline(curpt->x,  curpt->y,  curpt->col,
  	           nextpt->x, nextpt->y, nextpt->col);

    // then go to the next line
    curpt += 1;
    nextpt += 1;
  }

  // now, for convenience, we close the polygon for you :)
  nextpt = vertexlist;
  gpolyline(curpt->x,  curpt->y,  curpt->col,
	         nextpt->x, nextpt->y, nextpt->col);

  // now that we've stored all our x's and colour's into our global arrays,
  // let's do something with them!
  for (i = 0; i < 200; i++)
    if (startx[i] != -16000) {         // check to see if a line exists
      if (endx[i] == -16000)           // also check for an ending point
        endx[i] = startx[i];           // 'cause only one point could've been
                                       // found on the row

        // now draw a shaded line between the x's using the colours
        shadedline (startx[i], startcol[i], endx[i], endcol[i], i);
    }
}

gpoint mypoints[10];

void main (void) {
  int i;
  int n = 4;
  initgraph();

  // draw some random n point polys
  while(!kbhit()) {
    for(i = 0; i < n; i++) {
      mypoints[i].x = rand() % 320;
      mypoints[i].y = rand() % 200;
      mypoints[i].col = rand() % 256;
    }
    gpoly(mypoints, n);
  }
  getch();
  closegraph();
}
