/* Filled polygon demo.  Origionally written by Chris Egerter for
 * watcom C.  Converted/updated to DJGPP by Jeff Weeks (pweeks@execulink.com).
 */

#include <dos.h>
#include <go32.h>
#include <dpmi.h>
#include <conio.h>
#include <stdlib.h>
#include <sys/farptr.h>

#define putpixel(x,y,c) _farpokeb(_dos_ds, 0xA0000 + y * 320 + x, c);

// our global arrays
signed int startx[200];
signed int endx[200];

// a structure to hold points for a polygon
typedef struct { int x,y; } point;

void inline line(int x, int x2, int y, char c) {
  for(int i = x; i <= x2; i++) putpixel(i,y,c);
}

// This is basically a modified fixed point line drawing function which will
// store the line's x's and y's in the global arrays
void polyline (int x1, int y1, int x2, int y2) {
  int y;
  long x,xinc;

  if (y2 != y1) {                      // we don't want a horizontal line
    if (y2 < y1) {                     // make sure we're going in the right
      y1 ^= y2;                        // direction,  if not swap x,'s and y's
      y2 ^= y1;
      y1 ^= y2;

      x1 ^= x2;
      x2 ^= x1;
      x1 ^= x2;
    }

    x = (long)x1<<8;                   // start at our first x
    // this will find what we need to increment to our next x
    xinc = ((long)(x2 - x1)<<8) / ((long)(y2 - y1));

    // Here we skip the first point so that we don't end up storing the
    // point where two lines meet, twice.  Resulting in a single point drawn.
    x += xinc;
    y1++;

    for (y = y1; y <= y2; y++) {       // loop through each y
      if ((y >= 0) & (y < 200))        // check if we're in bounds
        if (startx[y] == -16000)       // if not empty
          startx[y] = x>>8;            // store into the first global array
        else
          endx[y] = x>>8;              // else store in the last global array
      x += xinc;                       // increment to the next x
    }
  }
}

// Draws a filled polygon given an array of vertices
void poly(point *vertexlist, int numvertex, char c) {
  int i;
  // Two pointers to a vertex. These are used to connect to vertices
  // together in when calling the polyline routine.
  point *curpt,*nextpt;

  curpt = vertexlist;
  nextpt = vertexlist + 1;

  for (i = 0; i < 200; i++) {
    startx[i] = endx[i] = -16000;      // Set up our impossible values
  }

  for (i = 1; i < numvertex; i++) {
    // Calculate the edge of this line
    polyline(curpt->x, curpt->y, nextpt->x, nextpt->y);
    // then go on to the next line
    curpt += 1;
    nextpt += 1;
  }

  // now we're nice enough to close the polygon for you
  nextpt = vertexlist;
  polyline(curpt->x, curpt->y, nextpt->x, nextpt->y);

  for (i = 0; i < 200; i++)            // loop through all our y's
    if (startx[i] != -16000) {         // check for a first and last coordinate
      if (endx[i] == -16000)
        endx[i] = startx[i];           // just incase only one point was found
    // Draw a line between the two x coordinates, on the row i, with colour c
    line (startx[i], endx[i], i, c);
  }
}

void initgraph(void) {
  __dpmi_regs regs;
  regs.x.ax = 0x13;
  __dpmi_int(0x10,&regs);
}

void closegraph(void) {
  __dpmi_regs regs;
  regs.x.ax = 0x3;
  __dpmi_int(0x10,&regs);
}

point mypoints[10];

void main (void) {
  int i;
  initgraph();

  while(!kbhit()) {
    for(i = 0; i < 4; i++) {
      mypoints[i].x = rand() % 320;
      mypoints[i].y = rand() % 200;
    }
    poly(mypoints, 4, rand() % 256);
  }
  getch();
  closegraph();
}